<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Doctor extends Model 
{

    protected $table = 'doctors';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name', 'phone', 'email', 'password', 'gender', 'is_active', 'description', 'lang', 'doctor_lang', 'exprince', 'appointment_type', 'exprinces_description', 'type', 'time_appointment', 'cost_appointment', 'commission');
    protected $hidden = array('password');

    public function sliders()
    {
        return $this->hasMany('App\Models\Slider');
    }

    public function workDays()
    {
        return $this->hasMany('App\Models\WorkDay');
    }

    public function packages()
    {
        return $this->hasMany('App\Models\Package');
    }

    public function orders()
    {
        return $this->hasMany('App\Models\Order');
    }

}